%% Code to generate Fig 7a
% SU-MIMO channel estimation NMSE
% L = 2, T_s = 1

clear all
close all
clc

% spread = 45

fig_name = 'Fig7a';

load([fig_name,'_AR_spread_45.mat'])
figure
plot(SNR_dB(1:2:end), 10*log10(MSE_ar_channel(1:2:end)), 'k--','LineWidth',1.2)
hold on

load([fig_name,'_sa_spread_45.mat'])

plot(SNR_dB(1:2:end), 10*log10(MSE_uq_channel(1:2:end)), 'r--d','LineWidth',1.2)
hold on
plot(SNR_dB(1:2:end), 10*log10(MSE_sd_channel(1:2:end)), 'b','LineWidth',1.2)
hold on

load([fig_name,'_UQ_spread_45.mat'])
plot(SNR_dB(1:1:end), 10*log10(MSE_uqf_channel(1:1:end)), 'm-.*','LineWidth',1.2)


% spread = 60 

load([fig_name,'_AR_spread_60.mat'])
plot(SNR_dB(1:2:end), 10*log10(MSE_ar_channel(1:2:end)), 'k-.s','LineWidth',1.2)
hold on

load([fig_name,'_sa_spread_60.mat'])
plot(SNR_dB(1:2:end), 10*log10(MSE_uq_channel(1:2:end)), 'r--s','LineWidth',1.2)
hold on
plot(SNR_dB(1:2:end), 10*log10(MSE_sd_channel(1:2:end)), 'b-s','LineWidth',1.2)
hold on

load([fig_name,'_UQ_spread_60.mat'])
plot(SNR_dB(1:1:end), 10*log10(MSE_uqf_channel(1:1:end)), 'm-.s','LineWidth',1.2)

grid on
legend('AR - 45^0','UQ - 45^0','SD - 45^0', 'UQ benchmark - 45^0', 'AR - 60^0','UQ - 60^0','SD - 60^0','UQ benchmark - 60^0'); 
legend('location','southwest')

xlim([-15 15])
xlabel('SNR (dB)')
ylabel('NMSE (dB)')

savefig([fig_name,'.fig'])
saveas(gcf,[fig_name],'epsc')
